/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.client;

import dev.compactmods.crafting.CompactCrafting;
import dev.compactmods.crafting.api.field.IMiniaturizationField;
import dev.compactmods.crafting.core.CCCapabilities;
import dev.compactmods.crafting.field.MiniaturizationField;
import dev.compactmods.crafting.projector.FieldProjectorBlock;
import dev.compactmods.crafting.projector.FieldProjectorEntity;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ClientPacketHandler {
    public static void handleFieldActivation(IMiniaturizationField field, CompoundTag fieldClientData) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_18689_(() -> {
            ClientLevel cw = mc.f_91073_;
            if (cw == null) {
                return;
            }
            field.setLevel((Level)cw);
            field.loadClientData(fieldClientData);
            mc.f_91073_.getCapability(CCCapabilities.FIELDS).ifPresent(fields -> fields.registerField(field));
        });
    }

    public static void handleFieldDeactivation(BlockPos center) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_18689_(() -> {
            ClientLevel cw = mc.f_91073_;
            cw.getCapability(CCCapabilities.FIELDS).ifPresent(fields -> {
                fields.get(center).map(IMiniaturizationField::getProjectorPositions).orElse(Stream.empty()).forEach(proj -> FieldProjectorBlock.deactivateProjector((Level)cw, proj));
                fields.unregisterField(center);
            });
        });
    }

    public static void handleFieldData(CompoundTag fieldData) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        MiniaturizationField field = new MiniaturizationField();
        field.setLevel((Level)mc.f_91073_);
        field.loadClientData(fieldData);
        mc.f_91073_.getCapability(CCCapabilities.FIELDS).ifPresent(fields -> {
            fields.setLevel((Level)mc.f_91073_);
            CompactCrafting.LOGGER.debug("Registering field on client");
            IMiniaturizationField fieldRegistered = fields.registerField(field);
            CompactCrafting.LOGGER.debug("Setting field references");
            field.getProjectorPositions().map(arg_0 -> ((ClientLevel)mc.f_91073_).m_7702_(arg_0)).map(tile -> (FieldProjectorEntity)((Object)((Object)tile))).filter(Objects::nonNull).forEach(tile -> {
                BlockState state = tile.m_58900_();
                tile.setFieldRef(fieldRegistered.getRef());
            });
        });
    }

    public static void removeField(BlockPos fieldCenter) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        mc.f_91073_.getCapability(CCCapabilities.FIELDS).ifPresent(fields -> fields.unregisterField(fieldCenter));
    }

    public static void handleRecipeChanged(BlockPos center, @Nullable ResourceLocation recipe) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        mc.f_91073_.getCapability(CCCapabilities.FIELDS).lazyMap(af -> af.get(center)).ifPresent(field -> field.ifPresent(f -> f.setRecipe(recipe)));
    }
}

